/*
 * ActionInfo.h
 *
 * Created 8/23/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/23/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef ACTION_INFO_H
 #define ACTION_INFO_H
 
 template <typename T> class ActionInfo;
 
 #include "global.h"
 
 #include "referenceCount.h"
 #include "pointerTo.h"
 #include "ActionTask.h"
 
 /**
  * Class specification for ActionInfo
  */
 template <typename T>
 class ActionInfo : public ReferenceCount
 {
 // Data Members
 private:
    double _time_action_was_invoked;
    
 // Local Functions
 public:
    ActionInfo( const double time_action_was_invoked = global::_clock_Ptr->get_real_time() );
    ActionInfo( const ActionInfo<T>& action_info );
    virtual ~ActionInfo();
    inline ActionInfo<T>& operator=( const ActionInfo<T>& action_info );
    inline double get_time_action_was_invoked() const;
    virtual inline void set_time_action_was_invoked( const double time );
    virtual inline void split_tasks( ActionTask<T>* action_task_Ptr, AsyncTaskManager* task_mgr_Ptr ) = 0;
 
 // Private Functions
 private:
    
 // Static Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  */
 template <typename T>
 ActionInfo<T>::ActionInfo( const double time_action_was_invoked )
               : ReferenceCount(),
                 _time_action_was_invoked( time_action_was_invoked )
 {
    
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 ActionInfo<T>::ActionInfo( const ActionInfo<T>& action_info )
               : ReferenceCount( action_info ),
                 _time_action_was_invoked( action_info._time_action_was_invoked )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 ActionInfo<T>::~ActionInfo()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified ActionInfo to this ActionInfo.
  *
  * @param (const ActionInfo<T>&) action_info
  * @return ActionInfo<T>&
  */
 template <typename T>
 inline ActionInfo<T>& ActionInfo<T>::operator=( const ActionInfo<T>& action_info )
 {
    ReferenceCount::operator=( action_info );
    _time_action_was_invoked = action_info._time_action_was_invoked;
    
    return *this;
 }
 
 /**
  * get_time_action_was_invoked() returns the global clock time the ActionTask,
  * containing this ActionInfo, was created.
  *
  * @return double
  */
 template <typename T>
 inline double ActionInfo<T>::get_time_action_was_invoked() const
 {
    return _time_action_was_invoked;
 }
 
 /**
  * set_time_action_was_invoked() sets the time the ActionTask was invoked to
  * the specified time.
  *
  * @param (const double) time
  */
 template <typename T>
 inline void ActionInfo<T>::set_time_action_was_invoked( const double time )
 {
    _time_action_was_invoked = time;
 }
 
 /** STATIC FUNCTIONS **/
 
 #endif // ACTION_INFO_H